/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.navigator.actions;

import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.ui.navigator.ProjectSiteConnection;
import com.aptana.ide.syncing.ui.navigator.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ProjectConnectionDisconnectAction
implements IObjectActionDelegate {
    protected ProjectSiteConnection projectConnection;
    protected IWorkbenchPart targetPart;

    public void run(IAction action) {
        final IConnectionPoint connectionPoint = (IConnectionPoint)this.projectConnection.getAdapter(IConnectionPoint.class);
        if (connectionPoint == null || !connectionPoint.canDisconnect()) {
            return;
        }
        Job job = new Job(MessageFormat.format(Messages.ProjectConnectionDisconnectAction_Disconnecting, connectionPoint.getName())){

            protected IStatus run(IProgressMonitor monitor) {
                if (ProjectConnectionDisconnectAction.this.targetPart instanceof CommonNavigator) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            CommonViewer viewer = ((CommonNavigator)(this).ProjectConnectionDisconnectAction.this.targetPart).getCommonViewer();
                            viewer.collapseToLevel((Object)(this).ProjectConnectionDisconnectAction.this.projectConnection, -1);
                        }
                    });
                }
                if (connectionPoint.canDisconnect()) {
                    try {
                        connectionPoint.disconnect(monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.setRule((ISchedulingRule)connectionPoint.getAdapter(ISchedulingRule.class));
        job.schedule();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.projectConnection = null;
        if (selection instanceof IStructuredSelection) {
            Object[] elements;
            Object[] objectArray = elements = ((IStructuredSelection)selection).toArray();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof ProjectSiteConnection) {
                    this.projectConnection = (ProjectSiteConnection)((Object)element);
                    break;
                }
                ++n2;
            }
        }
        action.setEnabled(this.projectConnection != null && this.projectConnection.canDisconnect());
    }
}

